#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>

/* =======================
   WIFI (MASTER NODE AP)
   ======================= */
const char* ssid     = "SmartWaterLevelController";
const char* password = "12345678";

/* =======================
   STATIC IP CONFIG
   ======================= */
IPAddress local_IP(192, 168, 4, 2);
IPAddress gateway(192, 168, 4, 1);
IPAddress subnet(255, 255, 255, 0);

/* =======================
   PINS
   ======================= */
#define WIFI_LED_PIN  D1   // 🔵 Blue LED (GPIO5)
#define RELAY_PIN     D2   // Relay Module(GPIO4)

/* =======================
   WEB SERVER
   ======================= */
ESP8266WebServer server(80);

/* =======================
   RELAY HANDLER
   ======================= */
void handleRelay() {
  if (!server.hasArg("state")) {
    server.send(400, "text/plain", "Missing state");
    return;
  }

  if (server.arg("state") == "1") {
    digitalWrite(RELAY_PIN, HIGH);
    Serial.println("🔌 RELAY ON");
    server.send(200, "text/plain", "RELAY_ON");
  } else {
    digitalWrite(RELAY_PIN, LOW);
    Serial.println("🔌 RELAY OFF");
    server.send(200, "text/plain", "RELAY_OFF");
  }
}

/* =======================
   WIFI CONNECT
   ======================= */
void connectWiFi() {
  WiFi.mode(WIFI_STA);
  WiFi.config(local_IP, gateway, subnet);
  WiFi.begin(ssid, password);

  Serial.print("📡 Connecting to AP");

  unsigned long start = millis();
  while (WiFi.status() != WL_CONNECTED && millis() - start < 15000) {
    delay(500);
    Serial.print(".");
    digitalWrite(WIFI_LED_PIN, !digitalRead(WIFI_LED_PIN)); // blink while connecting
  }

  if (WiFi.status() == WL_CONNECTED) {
    Serial.println("\n✅ CONNECTED");
    Serial.print("📍 IP: ");
    Serial.println(WiFi.localIP());
    digitalWrite(WIFI_LED_PIN, HIGH);   // 🔵 solid ON
  } else {
    Serial.println("\n❌ WIFI FAILED");
  }
}

/* =======================
   SETUP
   ======================= */
void setup() {
  Serial.begin(115200);
  delay(1000);

  Serial.println("\n🚀 RELAY NODE STARTING");

  pinMode(RELAY_PIN, OUTPUT);
  pinMode(WIFI_LED_PIN, OUTPUT);

  digitalWrite(RELAY_PIN, LOW);
  digitalWrite(WIFI_LED_PIN, LOW);

  connectWiFi();

  server.on("/relay", handleRelay);
  server.begin();

  Serial.println("🌐 HTTP SERVER READY");
}

/* =======================
   LOOP
   ======================= */
void loop() {
  static unsigned long lastBlink = 0;

  if (WiFi.status() == WL_CONNECTED) {
    digitalWrite(WIFI_LED_PIN, HIGH);   // 🔵 Connected → ON
  } else {
    if (millis() - lastBlink > 500) {   // 🔵 Disconnected → BLINK
      lastBlink = millis();
      digitalWrite(WIFI_LED_PIN, !digitalRead(WIFI_LED_PIN));
    }
    connectWiFi();
  }

  server.handleClient();
}
